<?php
/**
 * Server side rendering of the `btnsx/button` block.
 *
 * @package Buttons X
 */

/**
 * Get all buttons
 *
 * @since 1.9.70
 * @return void
 */
function btnsx_block_get_buttons() {
    // security check.
    check_ajax_referer( 'btnsx-block', 'security' );
    // query database
	global $wpdb;
    $btnsx_post = 'buttons-x';
    $btnsx_post_status = 'publish';
    $btnsx = $wpdb->get_results( $wpdb->prepare(
        "SELECT ID, post_title
            FROM $wpdb->posts 
            WHERE $wpdb->posts.post_type = %s
            AND $wpdb->posts.post_status = %s
            ORDER BY ID DESC",
        $btnsx_post,
        $btnsx_post_status
    ) );

    $list = array();

    foreach ( $btnsx as $btn ) {
        $selected = '';
        $btn_id = $btn->ID;
        $btn_name = $btn->post_title;
        $list[] = array(
            'title' =>	$btn_name,
            'id'	=>	$btn_id
        );
    }

    wp_send_json( $list );
}
add_action( 'wp_ajax_btnsx_block_get_buttons', 'btnsx_block_get_buttons' );

/**
 * Get button meta data
 *
 * @since 1.9.70
 * @return void
 */
function btnsx_block_get_meta() {
    // security check.
    check_ajax_referer( 'btnsx-block', 'security' );
    /*
     * Use get_post_meta() to retrieve an existing value
     * from the database and use the value for the form.
     */
    $meta_values = array();
    $meta_values = get_post_meta( $_POST['id'], 'btnsx', true );

    wp_send_json( $meta_values );
}
add_action( 'wp_ajax_btnsx_block_get_meta', 'btnsx_block_get_meta' );

/**
 * Server side block render
 *
 * @param array $attributes
 * @since 1.9.70
 * @return string
 */
function btnsx_block_render_button( $attributes ) {
    $block_content = do_shortcode('[btnsx id='. $attributes["id"] .']');
    return $block_content;
}

/**
 * Gutenberg block
 * 
 * @since 1.9.70
 * @return void
 */
function btnsx_block_gutenberg() {
    wp_register_script(
        'buttons-x-block',
        BTNSX__PLUGIN_URL . 'builders/gutenberg/assets/block.js',
        array('wp-blocks','wp-editor'),
        true
    );
    wp_localize_script( 'buttons-x-block', 'btnsx_block', array(
		'ajax_url'   => admin_url( 'admin-ajax.php' ),
		'ajax_nonce' => wp_create_nonce( 'btnsx-block' ),
	));
    register_block_type( 
        'btnsx/button', 
        array(
            'editor_script' => 'buttons-x-block',
            'attributes' => array(
                'id' => array(
                    'type' => 'string'
                )
            ),
            'render_callback' => 'btnsx_block_render_button',
        )
    );
}
add_action( 'init', 'btnsx_block_gutenberg' );